# A button class
import pygame

class button:  # A basic screen button widget

    def __init__ (self, scr, xx, yy, w, h):
        self.x = xx                  # Location: (x,y)
        self.y = yy
        self.width = w               # Size: width, height
        self.height = h
        self.label = ""              # Text label
        self.scr = scr               # Destination screen
        self.color = (200, 200, 200) # Button color
        self.image = None

    def setLabel (self, s):
        self.label = s
    def getLabel (self):
        return s

    def setColor (self, c):
      self.color = c
    def getColor (self):
        return self.color

    def setImage (self, im):
        self.image = im
    def getImage (self):
        return self.image

    def armed (self):
        if mouseX>=self.x and mouseX<=self.x+self.width and mouseY>=self.y and mouseY<=self.y+self.height:
            return True
        return False

    def draw (self):
        if self.armed():
            pygame.draw.rect(self.scr, (120, 220, 100), pygame.Rect(self.x, self.y, self.width, self.height))
        else:
            pygame.draw.rect (self.scr, (0,0,0), pygame.Rect(self.x, self.y, self.width, self.height), 1)
        pygame.draw.rect (self.scr, (0,0,0), pygame.Rect(self.x+3, self.y+3, self.width-6, self.height-6), 1)
        pygame.draw.rect (self.scr, self.color, pygame.Rect(self.x+4, self.y+4, self.width-8, self.height-8))
        if self.image != None:
            self.scr.blit(self.image, (self.x+4,self.y+4))

# Draw the underlying screen without the user drawn objects
def background ():
    global currentColor, screen, BLACK, textSurface

# Draw the basic window regions
    pygame.draw.line(screen, BLACK, (0, 600), (800, 600), 2)
    pygame.draw.line(screen, BLACK, (800, 0), (800, 600), 2)
    pygame.draw.line(screen, BLACK, (0, 0), (1000, 0), 2)
    pygame.draw.line(screen, BLACK, (1000, 0), (1000, 700), 2)
    pygame.draw.line(screen, BLACK, (1000, 700), (0, 700), 2)
    pygame.draw.line(screen, BLACK, (0, 700), (0, 0), 2)
    screen.blit(textsurface, (50, 630))

# Draw all of the buttons
    lineButton.draw()
    circleButton.draw()
    rectButton.draw()
    textButton.draw ()
    eraseButton.draw()
    saveButton.draw()
    thick1Button.draw()
    thick2Button.draw()
    thick3Button.draw()
    backButton.draw()
    foreButton.draw()
    blackButton.draw()
    redButton.draw()
    greenButton.draw()
    blueButton.draw()
    cyanButton.draw()
    yellowButton.draw()
    magentaButton.draw()
    greyButton.draw()
    whiteButton.draw()

    if currentColor == (255,255,255):   # Draw a box with the current color
        pygame.draw.rect(screen, currentColor, pygame.Rect(700, 630, 50, 50), 1)
    else:
        pygame.draw.rect(screen, currentColor, pygame.Rect(700, 630, 50, 50))

    if mouseX<=800 and mouseY <= 600:   # Draw the X coordinate of the mouse
        tempsurface = myfont.render(str(mouseX), False, (0, 0, 0))
        screen.blit(tempsurface, (90, 630))
        tempsurface = myfont.render(str(mouseY), False, (0, 0, 0))
        screen.blit(tempsurface, (200, 630))
# RGB of the current color
    tempsurface = myfont.render(str(currentColor[0]), False, (0, 0, 0))
    screen.blit(tempsurface, (380, 630))
    tempsurface = myfont.render(str(currentColor[1]), False, (0, 0, 0))
    screen.blit(tempsurface, (490, 630))
    tempsurface = myfont.render(str(currentColor[2]), False, (0, 0, 0))
    screen.blit(tempsurface, (600, 630))

def checkButtons():
    global mode, currentColor, thickness
    if lineButton.armed():
        mode = LINE
    elif circleButton.armed():
        mode = CIRCLE
    elif rectButton.armed():
        mode = RECTANGLE
    elif textButton.armed():
        mode = TEXT
    elif eraseButton.armed():
        mode = ERASE
    elif thick1Button.armed():
        thickness = 1
    elif thick2Button.armed():
        thickness = 2
    elif thick3Button.armed():
        thickness = 4
    elif saveButton.armed():
        save()
    elif backButton.armed():
        pushState()
    elif foreButton.armed():
        popState()
    elif blackButton.armed():
        currentColor = (0,0,0)
    elif redButton.armed():
        currentColor = (255,0,0)
    elif blueButton.armed():
        currentColor = (0,0,255)
    elif greenButton.armed():
        currentColor = (0,255,0)
    elif cyanButton.armed():
        currentColor = (0,255,255)
    elif yellowButton.armed():
        currentColor = (255,255,0)
    elif magentaButton.armed():
        currentColor = (255, 0, 255)
    elif greyButton.armed():
        currentColor = (200,200,200)
    elif whiteButton.armed():
        currentColor = (255,255,255)



screen = pygame.display.set_mode((1000, 700))  # Notice the tuple! It's not 2 arguments.
clock = pygame.time.Clock()
pygame.font.init()
myfont = pygame.font.SysFont('Comic Sans MS', 30)
textsurface = myfont.render('X          Y                   R          G          B', False, (0, 0, 0))

FPS = 60  # This variable will define how many frames we update per second.
BLACK = (0, 0, 0)
WHITE = (255, 255, 255)
#rect = pygame.Rect((0, 0), (32, 32))

# Initialize the images for the buttons
imageLine = pygame.Surface((42, 42))            # Draw line
imageLine.fill((200,200,200))
pygame.draw.line (imageLine, BLACK, (3,3), (38,38), 2)
imageT1 = imageLine = pygame.Surface((42, 42))  # Line size 1
imageT1.fill ((200,200,200))
pygame.draw.line (imageT1, BLACK, (3,21), (38,21), 1)
imageT2 = imageLine = pygame.Surface((42, 42))  # Line size 2
imageT2.fill ((200,200,200))
pygame.draw.line (imageT2, BLACK, (3,21), (38,21), 2)
imageT3 = imageLine = pygame.Surface((42, 42))  # Line size 3
imageT3.fill ((200,200,200))
pygame.draw.line (imageT3, BLACK, (3,21), (38,21), 4)
imageCircle = pygame.Surface((42, 42))
imageCircle.fill((200,200,200))
pygame.draw.circle(imageCircle, BLACK, (20,20), 10, 2)
imageRect = pygame.Surface ((42,42))
imageRect.fill((200,200,200))
pygame.draw.rect(imageRect, BLACK, (12,12, 18,18), 2)
imageErase = pygame.image.load ("erase.png")
imageSave = pygame.image.load ("save.png")
imageBack = pygame.image.load ("back.png")
imageFore = pygame.image.load ("fore.png")
imageText = pygame.image.load ("text.png")
# Initialize all of the buttons
lineButton   = button (screen, 825, 20, 50, 50)
lineButton.setImage (imageLine)
circleButton = button (screen, 825, 80, 50, 50)
circleButton.setImage (imageCircle)
rectButton   = button (screen, 825, 140, 50, 50)
rectButton.setImage (imageRect)
textButton   = button (screen, 825, 200, 50, 50)
textButton.setImage (imageText)
eraseButton  = button (screen, 825, 260, 50, 50)
eraseButton.setImage (imageErase)
thick1Button = button (screen, 825, 320, 50, 50)
thick1Button.setImage (imageT1)
thick2Button = button (screen, 825, 380, 50, 50)
thick2Button.setImage (imageT2)
thick3Button = button (screen, 825, 440, 50, 50)
thick3Button.setImage (imageT3)
saveButton   = button (screen, 825, 500, 50, 50)
saveButton.setImage (imageSave)
backButton   = button (screen, 885, 20, 50, 50)
backButton.setImage (imageBack)
foreButton = button (screen, 885, 80, 50, 50)
foreButton.setImage (imageFore)
blackButton   = button (screen, 885, 140, 50, 50)
blackButton.setColor (BLACK)
redButton   = button (screen, 885, 200, 50, 50)
redButton.setColor ((255, 0, 0))
greenButton  = button (screen, 885, 260, 50, 50)
greenButton.setColor ((0, 250, 0))
blueButton = button (screen, 885, 320, 50, 50)
blueButton.setColor ((0,0,255))
cyanButton = button (screen, 885, 380, 50, 50)
cyanButton.setColor ((0, 250, 250))
yellowButton = button (screen, 885, 440, 50, 50)
yellowButton.setColor ((255, 255, 0))
magentaButton = button (screen, 885, 500, 50, 50)
magentaButton.setColor ((255, 0, 255))
greyButton   = button (screen, 885, 560, 50, 50)
greyButton.setColor ((200,200,200))
whiteButton   = button (screen, 885, 620, 50, 50)
whiteButton.setColor (WHITE)
currentColor = (0,0,0)

while True:
    clock.tick(FPS)
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            quit()
        if event.type == pygame.MOUSEBUTTONUP:     # Mouse button was released
            checkButtons()
        elif event.type == pygame.KEYDOWN:
            if event.key == pygame.K_w:
                rect.move_ip(0, -2)  # Changes the rect's position.
            elif event.key == pygame.K_s:
                rect.move_ip(0, 2)
            elif event.key == pygame.K_a:
                rect.move_ip(-2, 0)
            elif event.key == pygame.K_d:
                rect.move_ip(2, 0)

    mouze = pygame.mouse.get_pos()
    mouseX = mouze[0]
    mouseY = mouze[1]
    screen.fill(WHITE)
    background ()            # Draw the paint window
    pygame.display.update()  # redraw the screen